/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.integration.StageHelper;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StageReward
extends Reward {
    public String stage = "";
    public boolean remove = false;

    public StageReward(Quest quest) {
        super(quest);
        this.autoclaim = RewardAutoClaim.INVISIBLE;
    }

    @Override
    public RewardType getType() {
        return RewardTypes.STAGE;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("stage", this.stage);
        if (this.remove) {
            nbt.m_128379_("remove", true);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.stage = nbt.m_128461_("stage");
        this.remove = nbt.m_128471_("remove");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.stage, Short.MAX_VALUE);
        buffer.writeBoolean(this.remove);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.stage = buffer.m_130136_(Short.MAX_VALUE);
        this.remove = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("stage", this.stage, v -> {
            this.stage = v;
        }, "").setNameKey("ftbquests.reward.ftbquests.gamestage");
        config.addBool("remove", this.remove, v -> {
            this.remove = v;
        }, false);
    }

    @Override
    public void claim(ServerPlayer player, boolean notify) {
        if (this.remove) {
            ((StageHelper)StageHelper.instance.m_13971_()).remove(player, this.stage);
        } else {
            ((StageHelper)StageHelper.instance.m_13971_()).add(player, this.stage);
        }
        if (notify) {
            if (this.remove) {
                player.m_6352_((Component)new TranslatableComponent("commands.gamestage.remove.target", new Object[]{this.stage}), Util.f_137441_);
            } else {
                player.m_6352_((Component)new TranslatableComponent("commands.gamestage.add.target", new Object[]{this.stage}), Util.f_137441_);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return new TranslatableComponent("ftbquests.reward.ftbquests.gamestage").m_130946_(": ").m_7220_((Component)new TextComponent(this.stage).m_130940_(ChatFormatting.YELLOW));
    }
}

